% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension.R
\docType{class}
\name{ExtensionType}
\alias{ExtensionType}
\title{ExtensionType class}
\description{
ExtensionType class
}
\section{Methods}{


The \code{ExtensionType} class inherits from \code{DataType}, but also defines
extra methods specific to extension types:
\itemize{
\item \verb{$storage_type()}: Returns the underlying \link{DataType} used to store
values.
\item \verb{$storage_id()}: Returns the \link{Type} identifier corresponding to the
\verb{$storage_type()}.
\item \verb{$extension_name()}: Returns the extension name.
\item \verb{$extension_metadata()}: Returns the serialized version of the extension
metadata as a \code{\link[=raw]{raw()}} vector.
\item \verb{$extension_metadata_utf8()}: Returns the serialized version of the
extension metadata as a UTF-8 encoded string.
\item \verb{$WrapArray(array)}: Wraps a storage \link{Array} into an \link{ExtensionArray}
with this extension type.
}

In addition, subclasses may override the following methods to customize
the behaviour of extension classes.
\itemize{
\item \verb{$deserialize_instance()}: This method is called when a new \link{ExtensionType}
is initialized and is responsible for parsing and validating
the serialized extension_metadata (a \code{\link[=raw]{raw()}} vector)
such that its contents can be inspected by fields and/or methods
of the R6 ExtensionType subclass. Implementations must also check the
\code{storage_type} to make sure it is compatible with the extension type.
\item \verb{$as_vector(extension_array)}: Convert an \link{Array} or \link{ChunkedArray} to an R
vector. This method is called by \code{\link[=as.vector]{as.vector()}} on \link{ExtensionArray}
objects, when a \link{RecordBatch} containing an \link{ExtensionArray} is
converted to a \code{\link[=data.frame]{data.frame()}}, or when a \link{ChunkedArray} (e.g., a column
in a \link{Table}) is converted to an R vector. The default method returns the
converted storage array.
\item \verb{$ToString()} Return a string representation that will be printed
to the console when this type or an Array of this type is printed.
}
}

