# News - 14 series

(release-14-14)=
## Release 14.14 - 2025-01-31

### Fixes

#### Fixed a bug that Mroonga packages use a previous version of Groonga

[GH-869](https://github.com/mroonga/mroonga/issues/869)

This bug only occurred in Mroonga 14.13.

Mroonga 14.13 must use Groonga 14.1.3.
However, Mroonga 14.13 uses Groonga 14.1.2 not 14.1.3.

So, please use Mroonga 14.14 instead of 14.13.

(release-14-13)=
## Release 14.13 - 2025-01-29

### Improvements

#### Added support for `mysql:8.4` Docker image

`mysql:*` Docker images use the `mysql-community-server-minimal`
package not the `mysql-community-server` package. So we need to build
Mroonga packages for not only `mysql-community-server` but also
`mysql-community-server-minimal` to use Mroonga in `mysql:*` Docker
images.

We published Mroonga packages only for MySQL 8.0's
`mysql-community-server-minimal` so far. In this release, we also
published Mroonga packages for MySQL 8.4's
`mysql-community-server-minimal`. So we can use Mroonga in `mysql:8.4`
Docker images.

(release-14-12)=
## Release 14.12 - 2024-12-25

### Fixes

#### Fixed a crash bug that may happen on shutdown

We don't have a concrete condition for this case. But we added some
`nullptr` checks for safety. It will fix this problem.

(release-14-10)=
## Release 14.10 - 2024-11-12

### Improvements

#### Improved `index_column_diff` support

[GH-789](https://github.com/mroonga/mroonga/issues/789)

Mroonga and underlying Groonga don't support `NULL`. So the behavior
of inserting `NULL` values is undefined by definition. This is not
changed (you should not use `NULL` with Mroonga!) but this release
changed some behaviors.

Groonga provides [`index_column_diff`
command](https://groonga.org/docs/reference/commands/index_column_diff.html). You
can use it to detect a broken index.

The current `NULL` related behavior may cause false positive broken
index detection. So this release changed some `NULL` related behavior
to avoid the false positive detection.

Note that this change also changed some `NULL` related behaviors but
you should not depend on the behavior! (We don't describe it in
details here because we don't want you to depend on the behavior.)

The behavior of the following types were changed:

* `bit`
* `datetime`
* `double`
* `enum`
* `float`
* `int`
* `set`
* `smallint`
* `time`
* `timestamp`
* `tinyint`
* `year`

The behavior of other types will be changed too in the future.

#### Added support for `bit`

[GH-798](https://github.com/mroonga/mroonga/issues/798)

The current `bit` implementation is completely broken. So nobody uses it...

This release rewrote the `bit` implementation completely. Now, `bit`
works well.

### Fixes

#### Fixed `year(2)`'s `70`-`99` handling

[GH-804](https://github.com/mroonga/mroonga/issues/804)

`70`-`99` must be processed as `1970`-`1999` but they are processed as
`2070`-`2099`. This release fixed this.

Note that you must not use `year(2)`. It's deprecated in MariaDB and
not supported in MySQL.

(release-14-08)=
## Release 14.08 - 2024-09-25

### Improvements

* We use CMake for building instead of the GNU Autotools.

  Using `configure` is deprecated. We recommend using `cmake` to build from source.

  Please refer [{doc}`/install/others`] about how to build from source with `cmake`.

### Fixes

* Fixed a bug that `SELECT` returned wrong result when we used multiple primary keys and primary keys included `VARBINARY` or `BLOB` type column. [GH-783][Reported by Jérome Perrin]

  If this bug occurred, the following query retrieved nothing.

  ```sql
  CREATE TABLE logs (
    id INT,
    content VARBINARY(256),
    PRIMARY KEY (id, content)
  ) ENGINE=Mroonga DEFAULT CHARSET=utf8mb4;

  INSERT INTO logs(id, content) VALUES (1, 'aaa');
  INSERT INTO logs(id, content) VALUES (2, 'bbb');

  SELECT * FROM logs WHERE content = 'aaa';
  ```

  This bug only occurred in Mroonga 14.07.

  This bug doesn't break an index. So, we don't need to execute `REINDEX` command after this fix.

### Thanks

* Jérome Perrin

(release-14-07)=
## Release 14.07 - 2024-09-06

### Improvements

* [{doc}`/install/almalinux`][{doc}`/install/debian`][{doc}`/install/ubuntu`] Added support for MySQL community 8.4.2.

* [{doc}`/install/almalinux`][{doc}`/install/debian`][{doc}`/install/ubuntu`] Added support for MySQL community 8.0.39.

* [{doc}`/install/almalinux`] Added support for Percona Server 8.0.37-29.

* [{doc}`/install/ubuntu`] Added support for MySQL 8.0.39

* [{doc}`/install/almalinux`] Added support for MariaDB 11.4.3, 10.11.9, 10.6.19, and 10.5.26.

* [{doc}`/install/ubuntu`] Added support for MariaDB 10.6.18 and 10.11.8.

* Disable descending index support [GitHub #764][Reported by Josep Sanz]

  If we don't add support for descending index with MariaDB >= 10.8, Mroonga returns wrong result with descending index.
  So, we disable descending index support now. However, we may re-try it later.

  By the way, if we use descending index with MySQL >= 8.0, MySQL returns error.

### Fixes

* Fix a crash bug with concurrent `FLUSH TABLES` and `INSERT`. [GitHub #743][Reported by Watson]

### Thanks

* Josep Sanz
* Watson

(release-14-04)=
## Release 14.04 - 2024-06-12

### Improvements

* [{doc}`/install/almalinux`] Added support for MariaDB 10.5.25, 10.6.18, and 10.11.8.

* [{doc}`/install/ubuntu`] Added support for MariaDB 10.11.7.

* [{doc}`/install/ubuntu`] Added support for MariaDB 10.6.18.

* [{doc}`/install/debian`] Added support for MariaDB 10.11.8.

* [{doc}`/install/ubuntu`] Added support for MySQL 8.0.36.

* [{doc}`/install/almalinux`][{doc}`/install/debian`][{doc}`/install/ubuntu`] Added support for MySQL Community Server 8.0.37.

* [{doc}`/install/almalinux`][{doc}`/install/debian`][{doc}`/install/ubuntu`] Added support for MySQL Community Server 8.4.

* [{doc}`/install/almalinux`] Added support for Percona Server 8.0.36-28.

* [{doc}`/install/ubuntu`] Added support for Ubuntu 24.04 (Noble Numbat).

* Dropped support MySQL Community Server 5.7.

  Because MySQL Community Server 5.7 reached EOL.

* Dropped support Percona Server 5.7

  Because Percona Server for MySQL 5.7 reached EOL.

* Dropped support for MariaDB 10.4.

  Because MariaDB 10.4 will reach EOL on 2024-06-18.

* Dropped support for MariaDB 10.7, 10.8, and 10.9.

  Because MariaDB 10.7, 10.8, and 10.9 reached EOL.

* Dropped support for MariaDB 10.10.

  Because the support term of MariaDB 10.10 is short.

* Dropped support for Amazon Linux 2.

  Because Groonga already dropped support for Amazon Linux 2.

* Dropped support for CentOS 7.

  Because CentOS 7 reached EOL.

* [{doc}`/install/debian`] Dropped support for Debian GNU/Linux bullseye.

  Because Debian GNU/Linux bullseye will reach EOL on 2024-07.

* Added functionality to output an error when Mroonga's UDF is used while Mroonga is uninitialized. [MDEV-21166][Reported by Ian Gilfillan.]

  Before this fix, using Mroonga's UDF without initializing Mroonga (not having run `INSTALL PLUGIN mroonga`) would cause a crash.
  This patch changes the output from a crash to logging an error.

### Fixes

* [{doc}`/tutorial/wrapper`] Fixed memory leaks in cases where engines not supporting online DDL are wrapped.

  In general, DDL operations like `ALTER TABLE` block access to the target table while in progress to maintain exclusive control.
  However, some storage engines allow operations on the target table during these operations (they can also be executed exclusively).
  The capability to operate on a table during such DDL operations is referred to as online DDL.

  The issue addressed occurs when wrapping storage engines that do not support online DDL in Mroonga's wrapper mode.
  It does not occur in storage mode or when using a combination of wrapper mode + InnoDB.

* [{doc}`/tutorial/storage`] Fixed a bug causing crashes when inserting into tables with compressed `VARCHAR` or `TEXT` columns. [MDEV-31966][Reported by Elena Stepanova.]

  This issue occurs only in storage mode and not in wrapper mode.

### Thanks

* Ian Gilfillan
* Elena Stepanova
