# Copyright(C) 2023  Sutou Kouhei <kou@clear-code.com>
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was GroongaConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(GRN_WITH_MESSAGE_PACK "TRUE")
set(GRN_WITH_BUNDLED_MESSAGE_PACK "TRUE")
set(GRN_PLUGINS_DIR "D:/a/groonga/groonga/install/groonga-15.2.6-4558a1e-x64-vs2022/lib/groonga/plugins")

include(CMakeFindDependencyMacro)

find_dependency(Threads)
if(DEFINED CMAKE_MODULE_PATH)
  set(GRN_CMAKE_MODULE_PATH_OLD ${CMAKE_MODULE_PATH})
else()
  unset(GRN_CMAKE_MODULE_PATH_OLD)
endif()
set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}")
if(GRN_WITH_MESSAGE_PACK AND NOT GRN_WITH_BUNDLED_MESSAGE_PACK)
  find_dependency(Groongamsgpackc)
endif()
if(DEFINED GRN_CMAKE_MODULE_PATH_OLD)
  set(CMAKE_MODULE_PATH ${GRN_CMAKE_MODULE_PATH_OLD})
  unset(GRN_CMAKE_MODULE_PATH_OLD)
else()
  unset(CMAKE_MODULE_PATH)
endif()

include("${CMAKE_CURRENT_LIST_DIR}/GroongaTargets.cmake")

check_required_components(Groonga)
